#ifndef GST_IntersectionInternalTypes_h__
#define GST_IntersectionInternalTypes_h__

#include "buildspec.h"

#include "Client/ClientUtils/IntersectionTemplateParser.hpp"

#include <boost/shared_ptr.hpp>

#include <boost/unordered_map.hpp>

namespace GST
{
namespace ClientUtils
{
struct GST_API_EXPORT IntersectionImageParameter
{
	GST::Utils::ImageDimension docDimension;
	GST::Utils::ImageDimension isecDimension;
	GST::Utils::ImageDimension legendDimension;

	IntersectionImageParameter();
	IntersectionImageParameter(const GST::Utils::ImageDimension &docDim,
							   const GST::Utils::ImageDimension &isecDim,
							   const GST::Utils::ImageDimension &legendDim);
};

struct GST_API_EXPORT IntersectionResult
{
	std::string intersectionImage;
	std::string legendImage;
	std::string scalebarImage;
	std::string legendInfo;
	long xScale;
	long yScale;
	double isecOutWidth;
	double isecOutHeight;
	boost::unordered_map<std::string, std::string> placeholderValues;

	IntersectionResult();
};
typedef boost::shared_ptr<IntersectionResult> IntersectionResultPtr;
} // namespace ClientUtils
} // namespace GST
#endif // GST_IntersectionInternalTypes_h__
